// PHPInterface.cpp

#define PHP_WIN32
#define ZEND_WIN32

#define ZEND_DEBUG 0

// Define ZTS if you are using multi-threaded PHP:
#define ZTS 1

#if defined(_MSC_VER)
  // Suppresses a bunch of silly warnings:
	#pragma warning(disable: 4100 4127 4267 4311 4505)
#endif

#include <PHP/php.h>

#include "mdName.h"
#include "PHPInterface.h"

zend_function_entry mdNamePHP_functions[]={
  ZEND_FE(mdNameCreate, NULL)
  ZEND_FE(mdNameDestroy, NULL)
	ZEND_FE(mdNameSetPathToNameFiles, NULL)
	ZEND_FE(mdNameInitializeDataFiles, NULL)
	ZEND_FE(mdNameGetInitializeErrorString, NULL)
	ZEND_FE(mdNameSetLicenseString, NULL)
  ZEND_FE(mdNameGetBuildNumber, NULL)
	ZEND_FE(mdNameGetDatabaseDate, NULL)
	ZEND_FE(mdNameGetDatabaseExpirationDate, NULL)
	ZEND_FE(mdNameGetLicenseExpirationDate, NULL)
  ZEND_FE(mdNameSetPrimaryNameHint, NULL)
  ZEND_FE(mdNameSetSecondaryNameHint, NULL)
  ZEND_FE(mdNameSetFirstNameSpellingCorrection, NULL)
  ZEND_FE(mdNameSetGenderPopulation, NULL)
  ZEND_FE(mdNameSetGenderAggression, NULL)
  ZEND_FE(mdNameAddSalutation, NULL)
	ZEND_FE(mdNameSetSalutationPrefix, NULL)
	ZEND_FE(mdNameSetSalutationSuffix, NULL)
	ZEND_FE(mdNameSetSalutationSlug, NULL)
	ZEND_FE(mdNameClearProperties, NULL)
	ZEND_FE(mdNameSetFullName, NULL)
	ZEND_FE(mdNameSetPrefix, NULL)
	ZEND_FE(mdNameSetPrefix2, NULL)
	ZEND_FE(mdNameSetFirstName, NULL)
	ZEND_FE(mdNameSetFirstName2, NULL)
	ZEND_FE(mdNameSetMiddleName, NULL)
	ZEND_FE(mdNameSetMiddleName2, NULL)
	ZEND_FE(mdNameSetLastName, NULL)
	ZEND_FE(mdNameSetLastName2, NULL)
	ZEND_FE(mdNameSetSuffix, NULL)
	ZEND_FE(mdNameSetSuffix2, NULL)
	ZEND_FE(mdNameParse, NULL)
	ZEND_FE(mdNameGenderize, NULL)
	ZEND_FE(mdNameSalutate, NULL)
	ZEND_FE(mdNameGetStatusCode, NULL)
	ZEND_FE(mdNameGetErrorCode, NULL)
	ZEND_FE(mdNameGetChangeCode, NULL)
	ZEND_FE(mdNameGetPrefix, NULL)
	ZEND_FE(mdNameGetPrefix2, NULL)
	ZEND_FE(mdNameGetFirstName, NULL)
	ZEND_FE(mdNameGetFirstName2, NULL)
	ZEND_FE(mdNameGetMiddleName, NULL)
	ZEND_FE(mdNameGetMiddleName2, NULL)
	ZEND_FE(mdNameGetLastName, NULL)
	ZEND_FE(mdNameGetLastName2, NULL)
	ZEND_FE(mdNameGetSuffix, NULL)
	ZEND_FE(mdNameGetSuffix2, NULL)
	ZEND_FE(mdNameGetGender, NULL)
	ZEND_FE(mdNameGetGender2, NULL)
	ZEND_FE(mdNameGetSalutation, NULL)
	{NULL, NULL, NULL}
};

zend_module_entry mdNamePHP_module_entry={
	STANDARD_MODULE_HEADER,
	"mdNamePHP Module",
	mdNamePHP_functions,
	NULL, 
	NULL, 
	NULL, 
	NULL, 
	NULL,
	NO_VERSION_YET,
	STANDARD_MODULE_PROPERTIES
};

ZEND_GET_MODULE(mdNamePHP)

ZEND_FUNCTION(mdNameCreate) {
	RETURN_LONG((long) (new mdName()));
}

ZEND_FUNCTION(mdNameDestroy) {
	long I;
  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0)
    return;

	delete (mdName*) I;
}

ZEND_FUNCTION(mdNameSetPathToNameFiles) {
  long I;
  const char *Path;
  int Len;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Path,&Len)==FAILURE || I==0)
		return;

	((mdName*) I)->SetPathToNameFiles(Path);
}

ZEND_FUNCTION(mdNameInitializeDataFiles) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_LONG(3);
		return;
	}

	RETURN_LONG(((mdName*) I)->InitializeDataFiles());
}

ZEND_FUNCTION(mdNameGetInitializeErrorString) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
    return;
  }

	RETURN_STRING((char*) ((mdName*) I)->GetInitializeErrorString(),1);
}

ZEND_FUNCTION(mdNameSetLicenseString) {
	long I;
  const char *License;
	int Len;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&License,&Len)==FAILURE || I==0) {
		RETURN_LONG(0);
    return;
  }
    	
	RETURN_LONG(((mdName*) I)->SetLicenseString(License));
}

ZEND_FUNCTION(mdNameGetBuildNumber) {
	long I;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
    return;
  }

	RETURN_STRING((char*) ((mdName*) I)->GetBuildNumber(),1);
}

ZEND_FUNCTION(mdNameGetDatabaseDate) {
	long I;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
    return;
  }

	RETURN_STRING((char*) ((mdName*) I)->GetDatabaseDate(), 1);
}

ZEND_FUNCTION(mdNameGetDatabaseExpirationDate) {
	long I;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
    return;
  }

	RETURN_STRING((char*) ((mdName*) I)->GetDatabaseExpirationDate(), 1);
}

ZEND_FUNCTION(mdNameGetLicenseExpirationDate) {
	long I;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
    return;
  }

	RETURN_STRING((char*) ((mdName*) I)->GetLicenseExpirationDate(), 1);
}

ZEND_FUNCTION(mdNameSetPrimaryNameHint) {
	long I;
	long NameHint;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ll",&I,&NameHint)==FAILURE || I==0) {
		RETURN_LONG(0);
    return;
   }
    	
	RETURN_LONG(((mdName*) I)->SetPrimaryNameHint((mdName::NameHints) NameHint));
}


ZEND_FUNCTION(mdNameSetSecondaryNameHint) {
	long I;
	long NameHint;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ll",&I,&NameHint)==FAILURE || I==0) {
		RETURN_LONG(0);
		return;
	}
    	
	RETURN_LONG(((mdName*)I)->SetSecondaryNameHint((mdName::NameHints) NameHint));
}

ZEND_FUNCTION(mdNameSetFirstNameSpellingCorrection) {
	long I;
	long Status;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ll",&I,&Status)==FAILURE || I==0) {
		RETURN_LONG(0);
		return;
	}
    	
	RETURN_LONG(((mdName*) I)->SetFirstNameSpellingCorrection(Status!=0));
}

ZEND_FUNCTION(mdNameSetGenderPopulation) {
	long I;
	long Population;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ll",&I,&Population)==FAILURE || I==0) {
		RETURN_LONG(0);
		return;
  }
    	
	RETURN_LONG(((mdName*) I)->SetGenderPopulation((mdName::Population) Population));
}

ZEND_FUNCTION(mdNameSetGenderAggression) {
	long I;
	long Aggression;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ll",&I,&Aggression)==FAILURE || I==0) {
		RETURN_LONG(0);
		return;
	}
    	
	RETURN_LONG(((mdName*) I)->SetGenderAggression((mdName::Aggression) Aggression));
}

ZEND_FUNCTION(mdNameAddSalutation) {
	long I;
	long Salutation;

  if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ll",&I,&Salutation)==FAILURE || I==0) {
		RETURN_LONG(0);
		return;
	}
    	
	RETURN_LONG(((mdName*) I)->AddSalutation((mdName::Salutations) Salutation));
}

ZEND_FUNCTION(mdNameSetSalutationPrefix) {
	long I;
	const char *Prefix;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Prefix,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*) I)->SetSalutationPrefix(Prefix);
}

ZEND_FUNCTION(mdNameSetSalutationSuffix) {
	long I;
	const char *Suffix;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Suffix,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*) I)->SetSalutationSuffix(Suffix);
}

ZEND_FUNCTION(mdNameSetSalutationSlug) {
	long I;
	const char *Slug;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Slug,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*) I)->SetSalutationSlug(Slug);
}

ZEND_FUNCTION(mdNameClearProperties) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0)
		return;

	((mdName*) I)->ClearProperties();
}

ZEND_FUNCTION(mdNameSetFullName) {
	long I;
	const char *Name;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Name,&Len)==FAILURE || I==0)
		return;

	((mdName*)I)->SetFullName(Name);
}

ZEND_FUNCTION(mdNameSetPrefix) {
	long I;
	const char *Prefix;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Prefix,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetPrefix(Prefix);
}

ZEND_FUNCTION(mdNameSetPrefix2) {
	long I;
	const char *Prefix;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Prefix,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetPrefix2(Prefix);
}

ZEND_FUNCTION(mdNameSetFirstName) {
	long I;
	const char *First;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&First,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetFirstName(First);
}

ZEND_FUNCTION(mdNameSetFirstName2) {
	long I;
	const char *First;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&First,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetFirstName2(First);
}

ZEND_FUNCTION(mdNameSetMiddleName) {
	long I;
	const char *Middle;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Middle,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetMiddleName(Middle);
}

ZEND_FUNCTION(mdNameSetMiddleName2) {
	long I;
	const char *Middle;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Middle,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetMiddleName2(Middle);
}

ZEND_FUNCTION(mdNameSetLastName) {
	long I;
	const char *Last;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Last,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetLastName(Last);
}

ZEND_FUNCTION(mdNameSetLastName2) {
	long I;
	const char *Last;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Last,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetLastName2(Last);
}

ZEND_FUNCTION(mdNameSetSuffix) {
	long I;
	const char *Suffix;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Suffix,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetSuffix(Suffix);
}

ZEND_FUNCTION(mdNameSetSuffix2) {
	long I;
	const char *Suffix;
	int Len;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"ls",&I,&Suffix,&Len)==FAILURE || I==0)
		return;
    	
	((mdName*)I)->SetSuffix2(Suffix);
}

ZEND_FUNCTION(mdNameParse) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_LONG(0);
		return;
	}

	RETURN_LONG(((mdName*) I)->Parse());
}

ZEND_FUNCTION(mdNameGenderize) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_LONG(0);
		return;
	}

	RETURN_LONG(((mdName*) I)->Genderize());
}

ZEND_FUNCTION(mdNameSalutate) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_LONG(0);
		return;
	}

	RETURN_LONG(((mdName*) I)->Salutate());
}

ZEND_FUNCTION(mdNameGetStatusCode) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
  }

	RETURN_STRING((char*) ((mdName*) I)->GetStatusCode(),1);
}

ZEND_FUNCTION(mdNameGetErrorCode) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetErrorCode(),1);
}

ZEND_FUNCTION(mdNameGetChangeCode) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetChangeCode(),1);
}

ZEND_FUNCTION(mdNameGetPrefix) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetPrefix(),1);
}

ZEND_FUNCTION(mdNameGetPrefix2) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetPrefix2(),1);
}

ZEND_FUNCTION(mdNameGetFirstName) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetFirstName(),1);
}

ZEND_FUNCTION(mdNameGetFirstName2) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetFirstName2(), 1);
}

ZEND_FUNCTION(mdNameGetMiddleName) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetMiddleName(), 1);
}

ZEND_FUNCTION(mdNameGetMiddleName2) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetMiddleName2(), 1);
}

ZEND_FUNCTION(mdNameGetLastName) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetLastName(), 1);
}

ZEND_FUNCTION(mdNameGetLastName2) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetLastName2(), 1);
}

ZEND_FUNCTION(mdNameGetSuffix) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetSuffix(), 1);
}

ZEND_FUNCTION(mdNameGetSuffix2) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetSuffix2(), 1);
}

ZEND_FUNCTION(mdNameGetGender) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetGender(), 1);
}

ZEND_FUNCTION(mdNameGetGender2) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetGender2(), 1);
}

ZEND_FUNCTION(mdNameGetSalutation) {
	long I;

	if (zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"l",&I)==FAILURE || I==0) {
		RETURN_STRING("",1);
		return;
	}

	RETURN_STRING((char*) ((mdName*) I)->GetSalutation(), 1);
}
